<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://contratar.simplescon.com');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Configurações da API PDF
define('PDF_API_URL', 'https://pierapi.azurewebsites.net/api/Solicitacoes/CriarNovoChamadoPDF');
define('API_USER', 'robson@simplescon.com');
define('API_PASS', 'Crasso00+');

// Função para autenticação (reutilizável)
function getAuthToken() {
    $authUrl = 'https://pierpublic.azurewebsites.net/login/validar?' . http_build_query([
        'login' => API_USER,
        'senha' => API_PASS
    ]);
    
    $ch = curl_init($authUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Accept: application/json'],
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        throw new Exception('Erro na autenticação: ' . curl_error($ch));
    }

    if ($httpCode !== 200) {
        throw new Exception('Falha na autenticação. Código HTTP: ' . $httpCode);
    }

    $data = json_decode($response, true);
    if (!$data || !isset($data['token'])) {
        throw new Exception('Token não recebido na resposta');
    }

    return $data['token'];
}

try {
    // Verificar método HTTP
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        exit(0);
    }

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido', 405);
    }

    // Obter dados do formulário
    $input = file_get_contents('php://input');
    $requestData = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Formato JSON inválido', 400);
    }

    // Validar campos obrigatórios
    $requiredFields = ['cliente_id', 'tiposolicitacao_id', 'responsavel_id', 'assunto', 'texto'];
    foreach ($requiredFields as $field) {
        if (empty($requestData[$field])) {
            throw new Exception("Campo obrigatório faltando: $field", 400);
        }
    }

    // Obter token de autenticação
    $token = getAuthToken();

    // Preparar requisição para a API de PDF
    $pdfPayload = [
        'cliente_id' => $requestData['cliente_id'],
        'tiposolicitacao_id' => $requestData['tiposolicitacao_id'],
        'responsavel_id' => $requestData['responsavel_id'],
        'assunto' => $requestData['assunto'],
        'texto' => $requestData['texto']
    ];

    $ch = curl_init(PDF_API_URL);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($pdfPayload),
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json',
            'Accept: application/json'
        ],
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        throw new Exception('Erro na conexão com a API de PDF: ' . $error, 500);
    }

    if ($httpCode !== 200) {
        $responseData = json_decode($response, true);
        $errorMsg = $responseData['message'] ?? 'Erro na API de PDF';
        throw new Exception($errorMsg, $httpCode);
    }

    $responseData = json_decode($response, true);
    
    // Verificar se o PDF foi realmente gerado
    if (!isset($responseData['idChamado']) || empty($responseData['listaArquivos'])) {
        throw new Exception('PDF foi criado mas não foi publicado corretamente', 500);
    }

    // Retornar resposta de sucesso com todos os dados
    echo json_encode([
        'success' => true,
        'message' => 'PDF gerado e publicado com sucesso',
        'idChamado' => $responseData['idChamado'],
        'numeroChamado' => $responseData['jsonSolicitacao'] ? json_decode($responseData['jsonSolicitacao'], true)[0]['Número'] : null,
        'nomeArquivo' => $responseData['listaArquivos'][0]['nomeArquivo'],
        'flgArquivoSalvoBlobs' => $responseData['listaArquivos'][0]['flgArquivoSalvoBlobs']
    ]);

} catch (Exception $e) {
    http_response_code($e->getCode() >= 400 ? $e->getCode() : 500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'code' => $e->getCode()
    ]);
}
?>