<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://contratar.simplescon.com');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Configurações da API
define('API_BASE_URL', 'https://pierpublic.azurewebsites.net');
define('AUTH_URL', API_BASE_URL . '/login/validar');
define('API_ENDPOINT', API_BASE_URL . '/solicitacao/abertura/abrirchamado');
define('API_USER', 'robson@simplescon.com');
define('API_PASS', 'Crasso00+');

// Função para autenticação
function getAuthToken() {
    $authUrl = AUTH_URL . '?' . http_build_query([
        'login' => API_USER,
        'senha' => API_PASS
    ]);
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $authUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Accept: application/json'],
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        error_log('Erro ao obter token: ' . curl_error($ch));
        return false;
    }

    curl_close($ch);

    if ($httpCode !== 200) {
        error_log('Erro HTTP ao obter token: ' . $httpCode);
        return false;
    }

    $data = json_decode($response, true);
    return $data['token'] ?? false;
}

// Função para formatar os dados do formulário
function formatarObservacoes($formData) {
    $observacoes = "DADOS DO SOLICITANTE:\n";
    $observacoes .= "• Nome Completo: " . ($formData['nome'] ?? 'Não informado') . "\n";
    $observacoes .= "• CPF: " . ($formData['cpf'] ?? 'Não informado') . "\n";
    $observacoes .= "• E-mail: " . ($formData['email'] ?? 'Não informado') . "\n";
    $observacoes .= "• Telefone: " . ($formData['telefone'] ?? 'Não informado') . "\n\n";
    
    $observacoes .= "ENDEREÇO:\n";
    $observacoes .= "• CEP: " . ($formData['cep'] ?? 'Não informado') . "\n";
    $observacoes .= "• Logradouro: " . ($formData['logradouro'] ?? 'Não informado') . "\n";
    $observacoes .= "• Número: " . ($formData['numero'] ?? 'Não informado') . "\n";
    $observacoes .= "• Complemento: " . ($formData['complemento'] ?? 'Não informado') . "\n";
    $observacoes .= "• Bairro: " . ($formData['bairro'] ?? 'Não informado') . "\n";
    $observacoes .= "• Cidade: " . ($formData['cidade'] ?? 'Não informado') . "\n";
    $observacoes .= "• Estado: " . ($formData['estado'] ?? 'Não informado') . "\n\n";
    
    $observacoes .= "DADOS DA EMPRESA:\n";
    $observacoes .= "• Nome da Empresa: " . ($formData['nome_empresa'] ?? 'Não informado') . "\n";
    $observacoes .= "• Tipo de Empresa: " . ($formData['tipo_empresa'] ?? 'Não informado') . "\n";
    $observacoes .= "• CNAE Principal: " . ($formData['cnae_principal'] ?? 'Não informado') . "\n";
    $observacoes .= "• Capital Social: R$ " . ($formData['capital_social'] ?? '0,00') . "\n\n";
    
    $observacoes .= "DESCRIÇÃO DAS ATIVIDADES:\n";
    $observacoes .= ($formData['descricao_atividades'] ?? 'Não informado') . "\n\n";
    
    $observacoes .= "OBSERVAÇÕES ADICIONAIS:\n";
    $observacoes .= ($formData['observacoes_adicionais'] ?? 'Nenhuma observação adicional');

    return $observacoes;
}

try {
    // Obter dados do formulário
    $requestData = $_SERVER['REQUEST_METHOD'] === 'POST' 
        ? json_decode(file_get_contents('php://input'), true)
        : $_GET;

    if (empty($requestData)) {
        throw new Exception('Nenhum dado recebido', 400);
    }

    // Validar campos obrigatórios
    $requiredFields = ['cliente_id', 'tiposolicitacao_id', 'responsavel_id', 'assunto'];
    foreach ($requiredFields as $field) {
        if (empty($requestData[$field])) {
            throw new Exception("Campo obrigatório faltando: $field", 400);
        }
    }

    // Obter token de autenticação
    $token = getAuthToken();
    if (!$token) {
        throw new Exception('Falha na autenticação com a API PIER', 401);
    }

    // Preparar parâmetros para a API
    $apiParams = [
        'cliente_id' => $requestData['cliente_id'],
        'tiposolicitacao_id' => $requestData['tiposolicitacao_id'],
        'responsavel_id' => $requestData['responsavel_id'],
        'assunto' => $requestData['assunto'],
        'observacoes' => formatarObservacoes($requestData)
    ];

    // Montar URL para a API PIER
    $apiUrl = API_ENDPOINT . '?' . http_build_query($apiParams);

    // Configurar requisição GET para a API PIER
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json'
        ],
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_FOLLOWLOCATION => true
    ]);

    // Executar a requisição
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        throw new Exception('Erro na conexão: ' . curl_error($ch), 500);
    }

    curl_close($ch);

    // Verificar resposta
    $responseData = json_decode($response, true);
    if ($httpCode !== 200) {
        $errorMsg = $responseData['message'] ?? 'Erro na API PIER (HTTP ' . $httpCode . ')';
        throw new Exception($errorMsg, $httpCode);
    }

    // Retornar resposta de sucesso
    echo json_encode([
        'success' => true,
        'protocolo' => $responseData['protocolo'] ?? 'N/A',
        'message' => 'Solicitação enviada com sucesso',
        'api_response' => $responseData // Para depuração
    ]);

} catch (Exception $e) {
    http_response_code($e->getCode() >= 400 ? $e->getCode() : 500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'code' => $e->getCode(),
        'trace' => $e->getTraceAsString() // Para depuração
    ]);
}
?>